{ Test program to load the employee table from the demo database hosted at www.nozicle.com/demodb.
  Note that the demo database is read only - the db_mysql_update.php script has not been installed }

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, ExtCtrls, Grids, DBGrids, Db, NozicleComponents,
  BaseDataset, ComCtrls;

type
  TfmMain = class(TForm)
    NozicleWebConnection: TNozicleWebConnection;
    DataSource: TDataSource;
    DBGrid: TDBGrid;
    Panel1: TPanel;
    DBNavigator1: TDBNavigator;
    buOpenDatabase: TButton;
    buCloseDatabase: TButton;
    NozicleDataset: TNozicleDataset;
    StatusBar: TStatusBar;
    StaticText1: TStaticText;
    buOpenDatabaseSQL: TButton;
    procedure buOpenDatabaseClick(Sender: TObject);
    procedure buCloseDatabaseClick(Sender: TObject);
    procedure buOpenDatabaseSQLClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateStatus;
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

procedure TfmMain.UpdateStatus;
begin
  if NozicleDataset.ErrorMessage <> '' then
    ShowMessage(NozicleDataset.ErrorMessage);
  StatusBar.Panels[0].Text := IntToStr(NozicleDataset.DataSetSize)+' Bytes (compressed)'; // no of bytes downloaded from server
  StatusBar.Panels[1].Text := IntToStr(NozicleDataset.DownloadTime)+' mSecs'; // time taken to download
  StatusBar.Panels[2].Text := IntToStr(NozicleDataset.RecordCount)+' rows';  // no of rows in the table
end;

procedure TfmMain.buOpenDatabaseClick(Sender: TObject);
begin
  NozicleDataset.Active := FALSE;
  NozicleDataset.DoSQL := FALSE;
  NozicleDataset.Active := TRUE;
  UpdateStatus;
end;

procedure TfmMain.buCloseDatabaseClick(Sender: TObject);
begin
  NozicleDataset.Active := FALSE;
end;

procedure TfmMain.buOpenDatabaseSQLClick(Sender: TObject);
begin
  NozicleDataset.Active := FALSE;
  NozicleDataset.DoSQL := TRUE;
  NozicleDataset.SQL := 'select concat(firstname," ",lastname) as Name, '+
                        'phoneext as "Phone Extension", '+
                        'hiredate as "Date Hired", '+
                        'Salary from employee '+
                        'order by name';
  NozicleDataset.Active := TRUE;
  UpdateStatus;
end;

end.
